! By H.X. Chen 6 March 2014 at HKUST
! Edited by P. Shen 11 Dec 2015 at HKUST
! subroutine to read the hydrograph saving cell number
subroutine hydro_read(ulog,uhydro)
use input_file_defs;use hydro_vars
implicit none
integer i,j,linct
integer,intent(in)::ulog,uhydro
logical ans

hydrocellfil='hydrograph.txt'
inquire (file=trim(hydrocellfil),exist=ans)
if(ans) then
    open (uhydro,file=trim(hydrocellfil),status='old',err=301)
    write (*,*) 'Opening default hydrograph cell file'
else
    write (*,*) 'Cannot locate default hydrograph cell file, <hydrograph.txt>'
    write (*,*) 'Type name of hydrograph cell file and'
    write (*,*) 'press RETURN to continue'
    read (*,'(a)') hydrocellfil
    open (uhydro,file=trim(hydrocellfil),status='old',err=301)
end if

write (ulog,*) 'hydrograph cell file -->',hydrocellfil
write (ulog,*) '-- LISTING OF HYDROGRAPH CELL FILE --'	

!! write copy of data to log file
!linct=1
!read (uhydro,'(a)',err=520) heading;linct=linct+1
!read (uhydro,*,err=520) htout;linct=linct+1
!write (ulog,*) heading
!write (ulog,*) htout

read (uhydro,'(a)',err=520) heading;linct=linct+1
read (uhydro,*,err=520) nohydrocell;linct=linct+1
write (ulog,*) heading
write (ulog,*) nohydrocell

allocate (hydrocell(nohydrocell))
!allocate (inflowht(noinflow,nopulse),inflowhq(noinflow,nopulse),inflowhcv(noinflow,nopulse))

do i=1,nohydrocell
    read (uhydro,*,err=520) hydrocell(i);linct=linct+1
    write (ulog,*)  hydrocell(i)
end do

write (ulog,*) 'Read the hydrograph cell successfully!'
close (uhydro)
return
301	continue
	write (*,*) '*** Error opening hydrograph cell file *** 301'
	write (*,*) '--> ',trim(hydrocellfil)
	write (*,*) 'Check file location and name'
    write (ulog,*) '*** Error opening hydrograph cell file ***'
    write (ulog,*) '--> ',trim(hydrocellfil)
    write (ulog,*) 'Check file location and name'
	pause 'Press RETURN to exit'
	stop '301'
520	continue
  	write (*,*) 'Error reading hydrograph cell file 520'
	write (*,*) '--> ',trim(hydrocellfil), 'at line ',linct
	write (*,*) 'Check file contents and organization'
  	write (ulog,*) 'Error reading hydrograph cell file'
	write (ulog,*) '--> ',trim(hydrocellfil), 'at line ',linct
	write (ulog,*) 'Check file contents and organization'
	pause 'Press RETURN to exit'
	stop '520'
end